/*
  De derecha a izquierda: CLK, DT, MS, 5V i GND
  El SW se conecta a 5V, con una resisténcia de 10K. El SW es el botón incorporada al encoder
  CLK = Gris        Pin 6
  DT  = Blanc/gris  Pin 5
  SW  = Marron      Pin 4
  5V  = Varmell
  GND = Negre
  Restabli teclat mac
  sudo rm /Library/Preferences/com.apple.keyboardtype.plist

*/

// Incluye la:
#include <LiquidCrystal_I2C.h>
//******************
#include "Keyboard.h"    // Esta es una biblioteca "incorporada" sin necesidad de instalar pero se tiene que modificar al castellano
#include <SoftwareSerial.h>
#include <Keypad.h>
#include <Wire.h>

#define RxD 0    // Usado para conexion rs232 virtual.
#define TxD 1    // Usado para conexion rs232 virtual.
SoftwareSerial comVirtual(RxD, TxD);

LiquidCrystal_I2C lcd (0x27, 16, 2);  // Inicia el LCD en la dirección 0x27, con 16 caracteres y 2 líneas

     // Array de caracteres 
char Tecles[22] = {'@','<','>','[',']','{','}','(',')','|','&',
                   '$','#','"','%','+','-','*','/','=','?','^'};

// Declaro Encoder
int pinEnt = 4;  // Conectado al SW 
int pinA = 6;    // Conectado al CLK 
int pinB = 5;    // Conectado al DT 
int Pos = -1;    // Es el que indica la posición del encoder

unsigned long time;
unsigned long t;
unsigned long tEnt;
bool C = true;
bool D = true;
bool E = false;
bool Ent = false;
int EncMenu = Pos;
String Cadena = "";

    // Representación binaria de las dos flechas que se mostraran en la LCD
byte derecha[8] = {B00000, B00010, B00110, B01110, B11111, B01110, B00110, B00010};
byte izquierda[8]   = {B00000, B01000, B01100, B01110, B11111, B01110, B01100, B01000};


void setup() {
  // Inicio puerto serie
  Serial.begin (9600);
  comVirtual.begin(9600);
  Wire.begin();
  

  //LCD
  // configure el número de columnas y filas de la pantalla LCD:
  lcd.begin(16, 2);
  //lcd.cursor();   // Muestra el cursor
  //lcd.blink();    // Parpadeo del cursor
  lcd.backlight();
  lcd.clear();
  lcd.createChar (1, izquierda);  // Creamos el primer caracter. Los valores atmitidos 0 a 7
  lcd.createChar (2, derecha);  // Creamos el segundo caracter. Los valores atmitidos 0 a 7

  //lcd.rightToLeft(); // Escribe hacia la izquerra.
  //lcd.leftToRight(); // Escribe hacia la derecha.
  //lcd.backlight();   // Enciende la luz de fondo de la LCD
    
  // Declaro pines Encoder
  pinMode (pinA,INPUT);   // Derecha
  pinMode (pinB,INPUT);   // Izquierda
  pinMode (pinEnt,INPUT); // Enter

  for(int i=0; i<22; i++){
    if (i<=10){
      lcd.setCursor(i, 0);
      lcd.write(Tecles[i]);
    } else {
      lcd.setCursor(i-11, 1);
      lcd.write(Tecles[i]);
    }  
  } 
  //***** Flechas
  lcd.setCursor(11, 0);
  lcd.print(" Car.");
  lcd.setCursor(11, 1);
  lcd.print("     ");
  lcd.setCursor(12, 1);
  lcd.write (1);
  lcd.setCursor(14, 1);
  lcd.write (2);
}

void loop() {
  time = millis(); // Registra el tiempo en todo el programa 
  //y lo usare en las distintas instancias.

  // -------------------------------------------------------
  // Codigo del encoder
  //*** Giro a la derecha ***
    if (digitalRead(pinA)==LOW){
      t = time;
      if(C == true){
        Pos ++;   
        if (Pos >=22){
            Pos = 0;
          }
        Serial.print("Encoder Position dreta: ");
        Serial.println(Pos);  //Posición en la matriz
        lcd.setCursor(13, 1);
        lcd.write(Tecles[Pos]);
        C = false;
        D = false;
      }
    }  
  //*** Giro a la izquierda ***
    if (digitalRead(pinB)==LOW){
      t = time;
      if(D == true){
        Pos --;   
        if (Pos<= -1){
            Pos = 21;
        }    
      Serial.print("Encoder Position esquerra: ");
      Serial.println(Pos);  //Posición en la matriz
      lcd.setCursor(13, 1);
      lcd.write(Tecles[Pos]);
      C = false;
      D = false;
      }  
    }
     if (time-t>8){ // Tengo que esperar 8 ms para registrar nuevamente
        C = true;
        D = true;
     }
  
//****** Tecla pulsada *******************
    // Enter
  if(E == false){
    if(digitalRead(pinEnt) == LOW){
      E = true;
    }
  }


  if(E == true){
    if(digitalRead(pinEnt) == HIGH){
      Serial.println(Tecles[Pos]);
      Keyboard.begin();
      Keyboard.write(Tecles[Pos]);
      delay(200);
      E = false;
    }
  } 
}
