#include <Keypad.h>
#include "Keyboard.h"    // This is a "built-in" library no need to install
#include <Mouse.h>
#include <SoftwareSerial.h>
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
  
LiquidCrystal_I2C lcd(0x27, 16, 2);  // set the LCD address to 0x27 for a 20 chars and 4 line display



#define RxD 0                             // Usado para conexion rs232 virtual.
#define TxD 1                             // Usado para conexion rs232 virtual.


const byte filas = 4;     //Numero de filas del teclado
const byte columnas = 4;  //Numero de columnas del teclado

//Defino una matriz 4x4 con la posicion de las filas y columnas
char matriz[filas][columnas] =
{

  { '@', '<', '>', 'A'},
  { '#', '{', '}', 'B'},
  { '(', ')', '/', 'C'},
  { '*', '0', '#', 'D'},

};

byte pinesFilas[filas] = {5, 6, 7, 8};       //Pines donde van conectadas las filas del teclado
byte pinesColumnas[columnas] = {9, 10, 11, 12}; //Pines donde van conectadas las columnas del teclado

/*
 * byte pinesFilas[filas] = {12, 11, 10, 9};       //Pines donde van conectadas las filas del teclado
 * byte pinesColumnas[columnas] = {8, 7, 6, 5}; //Pines donde van conectadas las columnas del teclado

 */

//Inicializo el teclado con el numero de filas, columnas, los pines del Arduino utilizados y la matriz
Keypad teclado = Keypad( makeKeymap(matriz), pinesFilas, pinesColumnas, filas, columnas);

SoftwareSerial comVirtual(RxD, TxD);

void setup()
{
  Serial.begin(9600);   //Inicializo el puerto serie
  lcd.init();                      // initialize the lcd 
  lcd.backlight();
  lcd.setCursor(0, 0);
  lcd.clear();
  lcd.setCursor(2, 0);
  lcd.print("Hola Teclat");
  lcd.setCursor(1, 1);
  lcd.print("joseprommy.com");
  delay(1000);
  lcd.setCursor(0, 0);
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("@<> #{} []& ()/");
  lcd.setCursor(1, 1);
  lcd.print("joseprommy.com");
  
}

void loop()
{
  char tecla_presionada = teclado.getKey();    //Almaceno en una variable la tecla presionada

  if (tecla_presionada)
  {
    Serial.println(tecla_presionada);   //Muestra la tecla presionada en el monitor serie
    Keyboard.begin();         //begin keyboard 
   // if (digitalRead(4) == 0){       //Si el boto 4 es pressionat
        Keyboard.write(tecla_presionada);        //Envia "@"
        delay(200);
 
   //}
  }
} 
